# Damak AI Agent Project

This repository provides a simple starting point for a bilingual (Arabic/English) AI agent running as a web application. It includes:

- A webhook endpoint (`/webhook`) for handling incoming chat messages and generating responses via OpenAI's API.
- A minimal dashboard (`/dashboard`) and upload form (`/upload`) so administrators can upload PDF or Word documents. These files are stored in the `uploads/` folder for future processing.
- Templates built with plain HTML for simplicity and Arabic right-to-left support.

## Features

1. **AI Chat Endpoint**: The `/webhook` route reads the incoming message (`Body` or `message`) and sends a prompt to OpenAI's API. Responses are in the same language as the user.
2. **File Uploads**: Use `/upload` to add new PDF or Word documents. Uploaded files are saved on the server.
3. **Dashboard**: Navigate to `/dashboard` to see a list of uploaded files.

## Setup Instructions

1. **Install Dependencies**

   ```bash
   pip install -r requirements.txt
   ```

2. **Set Your API Key**

   Copy `.env.example` to `.env` and replace `your-api-key-here` with your actual OpenAI API key.

   ```bash
   cp .env.example .env
   # then edit .env and add your OpenAI API key
   ```

3. **Run the Application Locally**

   ```bash
   python app.py
   ```

   By default, the server runs on port 5000. You can access the dashboard at `http://localhost:5000/dashboard` and the upload form at `http://localhost:5000/upload`.

## Deployment on cPanel

1. Upload the entire `damak_ai_agent` directory to your cPanel account (or just the contents of this directory into your project root).
2. Set up a Python application via the cPanel interface and choose Python 3.x as the runtime.
3. Install the dependencies by running `pip install -r requirements.txt` using the Terminal or the cPanel application manager.
4. Create a `.env` file in the application root and set your `OPENAI_API_KEY`.
5. Configure your webhook URL in your WhatsApp or Twilio console to point to `https://your-domain.com/webhook`.

## Notes

- This project uses a simple prompt to generate AI replies. Depending on your needs, you can extend the conversation logic, add error handling, or integrate additional services.
- Uploaded files are saved in the `uploads/` directory but not processed by the AI in this example. You can extend the code to extract text from PDFs or Word documents and include that information in the responses.